function [newfilenames] = findfiletype(filenames,ext)
%This little function takes a list of filenames, as output by the dir
%function, and finds files of a specific type.  A more generalized version
%of findimgs
%Synatax:   [newfilenames] = findfiletype(filenames,ext)
%Input:     filenames = name of files in a cell row vector, e.g.,
%           {file.tif,file2.tif,metadata.txt...}
%           ext = the extension type, e.g., .txt,.csv..., if a row cell
%           vector of extensions will look for all, e.g.,
%           {'.csv','.txt'...}
%Output:    newfilenames = the names of image files in a cell row vector,
%           e.g., {file.tif,file2.tif}

if nargin<2
    ext = {'.csv'};   %default look for csv files
else
    if ischar(ext)   %convert of cell array if a string is entered
        ext = {ext};
    end
end

idx_all = [];
for j = 1:size(ext,2)
    %first look for all the extensions
    idx = strfind(filenames,ext{j});
    %put the indexes together
    idx_all = vertcat(idx_all,idx);
end

newfilenames = {};
%now go through each file and remove the none image files
itr = 1;    %independent file pointer
for i = 1:size(filenames,2)
    if ~isempty(cell2mat(idx_all(:,i)))     %if this file is a supported type
        newfilenames{itr} = filenames{i};   %keep filename
        itr = itr+1;    %iterate up
    end
end